#!/bin/sh
#
# This is a driver installer for eGalaxTouch controller.
#
# Company: eGalax_eMPIA Technology Inc. (EETI)
# Version: 1.02.1401
# Released: 2012/02/01
# Support: touch_fae@eeti.com
#

eGTouchfolder="eGTouchARM"
drivername="eGTouch"
eGTouchD="eGTouchD"
eGTouchdIni="eGTouchL.ini"
utilityTool="eCalib"
installpath="/usr/local"
etcpath="/etc"
shortcutpath="/usr/bin"
rclocalpath="/etc/rc.local"		# Ubuntu and Fedora
rclocalpath1="/etc/init.d/boot.local"	# OpenSuSe 11.04
rclocalpath2="/etc/rc.d"		# Fedora 16
rclocalfile="rc.local"			# Fedora 16
blacklistpath="/etc/modprobe.d/blacklist.conf"
trash="/dev/null"
xorgfile="52-egalax-virtual.conf"
xorgpath="/usr/share/X11/xorg.conf.d"	# Ubuntu and Fedora
xorgpath1="/etc/X11/xorg.conf.d"	# OpenSuSe 11.04
paramfile="eGTouch.param"
parampath="/var/lib"

ShowTitle() {
    echo ""
    echo "(*) Linux eGTouch driver installer for eGalaxTouch controller "
    echo ""
}

CheckPermission() {
    echo -n "(I) Check user permission:"
    account=`whoami`
    if [ ${account} = "root" ]; then
        echo " ${account}, you are the supervisor."
    else
        echo " ${account}, you are NOT the supervisor."
        echo "(E) The root permission is required to run this installer."
        echo ""
        exit 1
    fi
}

ExtractDriver() {
    if [ -e ${parampath}/${paramfile} ]; then
        rm -f ${parampath}/${paramfile}
    fi
	
	if [ -e ${installpath}/${eGTouchfolder} ]; then
        rm -rf ${installpath}/${eGTouchfolder}
		echo "(I) Remove previous driver folder with return ${?}"
    fi

    cp -rf ${eGTouchfolder} ${installpath}
	driverpath="${installpath}/${eGTouchfolder}"
    ( cd ${driverpath}; chown root:root ${utilityTool}; chmod 4755 ${utilityTool})
    echo "(I) Place ${drivername} driver archive to ${driverpath}."

    if [ -d ${installpath}/${eGTouchfolder} ]; then
	echo "(I) Copy ${eGTouchdIni} to ${etcpath}."
	cp ${installpath}/${eGTouchfolder}/${eGTouchdIni} ${etcpath}
    else
	echo "(E) The ${eGTouchdIni} can NOT be copied to ${etcpath}."
	exit 1
    fi

    if [ -d ${shortcutpath} ]; then
        echo "(I) Create ${drivername} daemon shortcut in ${shortcutpath}."
        chmod a+x ${driverpath}/${eGTouchD}
        ln -sf ${driverpath}/${eGTouchD} ${shortcutpath}

        echo "(I) Create ${utilityTool} tool shortcut in ${shortcutpath}."
	chmod a+x ${driverpath}/${utilityTool}
        ln -sf ${driverpath}/${utilityTool} ${shortcutpath}
    else
        echo "(W) The shortcut can NOT be created in ${shortcutpath}."
    fi
}

RemoveeGTouchFile() {
    if [ -e ${parampath}/${paramfile} ]; then
        rm -f ${parampath}/${paramfile}
    fi

    if [ -e ${etcpath}/${eGTouchdIni} ]; then
        rm -rf ${etcpath}/${eGTouchdIni}
        echo "(I) Removed ${eGTouchdIni} file from ${etcpath}."
    else
        echo "(W) No ${etcpath}/${eGTouchdIni} file found."
    fi

}

RemoveShortcut() {
    if [ -d ${shortcutpath} ]; then
        if [ -L ${shortcutpath}/${eGTouchD} ]; then
            rm -f ${shortcutpath}/${eGTouchD}
            echo "(I) Removed ${eGTouchD} shortcut from ${shortcutpath}."
        else
            echo "(W) No ${shortcutpath}/${eGTouchD} shortcut found."
        fi
        
        if [ -L ${shortcutpath}/${utilityTool} ]; then
            rm -f ${shortcutpath}/${utilityTool}
            echo "(I) Removed ${utilityTool} shortcut from ${shortcutpath}."
        else
            echo "(W) No ${shortcutpath}/${utilityTool} shortcut found."
        fi
    else
        echo "(W) No ${shortcutpath} folder found."
    fi
}

AddeRclocalConfiguration() {
    echo "(I) Append ${drivername} daemon into $1."
    filelines=`cat $1 | wc -l`
    sed -i ''${filelines}'i\### Beginning: Launch eGTouch daemon while setup boot-up ###\
/usr/bin/eGTouchD\
### End: Launch eGTouch daemon while setup boot-up ###' $1
}

RemoveRclocalConfiguration() {
	checkdist="X -version"
    distfile="Dist.info"
    ${checkdist} > ${distfile} 2>&1
	
	grep -q "SUSE" ${distfile} # for Open SuSe 11.04
	if [ $? -eq 0 ]; then
		if [ -e ${rclocalpath1} ]; then
			sed -i '/### Beginning: Launch eGTouch daemon while setup boot-up ###/,/### End: Launch eGTouch daemon while setup boot-up ###/d' ${rclocalpath1}
			echo "(I) Removed ${drivername} daemon from ${rclocalpath1}."
		fi
	else
		grep -q "Build ID: xorg-x11-server 1.11.1-1.fc16" ${distfile} 	# for Fedora 16
		if [ $? -eq 0 ]; then
			echo "(I) Removed rc.local file: ${rclocalfile} from ${rclocalpath2}."
			rm -f ${rclocalpath2}/${rclocalfile}
		else	
			if [ -e ${rclocalpath} ]; then		# for Ubuntu 11.04 and Fedora 15
				sed -i '/### Beginning: Launch eGTouch daemon while setup boot-up ###/,/### End: Launch eGTouch daemon while setup boot-up ###/d' ${rclocalpath}
				echo "(I) Removed ${drivername} daemon from ${rclocalpath}."
			else
				echo "(E) No ${rclocalpath} or ${rclocalpath1} file found."
			fi
		fi
	fi

	rm -f ${distfile}
}

EditeGTouchdFile() {
	checkdist="X -version"
    distfile="Dist.info"
    ${checkdist} > ${distfile} 2>&1
	
	grep -q "SUSE" ${distfile} # for Open SuSe 11.04
	if [ $? -eq 0 ]; then
		if [ -w ${rclocalpath1} ]; then
			echo "(I) Found ${rclocalpath1} file."
			grep -q "### Beginning: Launch eGTouch daemon while setup boot-up ###" ${rclocalpath1}
			if [ $? -eq 1 ]; then
				AddeRclocalConfiguration ${rclocalpath1}
			else
				RemoveRclocalConfiguration
				AddeRclocalConfiguration ${rclocalpath1}
			fi
		else
			RemoveDriver
			echo "(E) No ${rclocalpath1} file found."
			echo ""
			exit 1
		fi
	else
		grep -q "Build ID: xorg-x11-server 1.11.1-1.fc16" ${distfile} # for Fedora 16
		if [ $? -eq 0 ]; then
			if [ -e ${rclocalpath2}/${rclocalfile} ]; then
				echo "(W) Found rc.local file: ${rclocalpath2}."
			else
				echo "(I) Copy rc.local file: ${rclocalfile} to ${rclocalpath2}."
				cp -f ${installpath}/${eGTouchfolder}/Rule/${rclocalfile} ${rclocalpath2}
			fi
		else
			if [ -w ${rclocalpath} ]; then	# for Ubuntu 11.04 and Fedora 15
				echo "(I) Found ${rclocalpath} file."
				grep -q "### Beginning: Launch eGTouch daemon while setup boot-up ###" ${rclocalpath}
				if [ $? -eq 1 ]; then
					AddeRclocalConfiguration ${rclocalpath}
				else
					RemoveRclocalConfiguration
					AddeRclocalConfiguration ${rclocalpath}
				fi
        		else
				RemoveDriver
				echo "(E) No ${rclocalpath} file found."
				echo ""
				exit 1
			fi
		fi
	fi
	
	rm -f ${distfile}
}

Add2Blacklist() {
    if [ -w ${blacklistpath} ]; then
        grep -q $1 ${blacklistpath}
        if [ $? -eq 1 ]; then
            filelines=`cat ${blacklistpath} | wc -l`
            echo "(I) Add kernel module $1 into ${blacklistpath}."
            sed -i ''${filelines}'a\### Beginning: blacklist usbtouchscreen ###\
blacklist usbtouchscreen\
### End: blacklist usbtouchscreen ###' ${blacklistpath}
        else
            echo "(I) The kernel module $1 has been added in ${blacklistpath}."
        fi
    fi
}

ShowBlacklistMenu() {
    echo "(I) It is highly recommended to add it into blacklist."
    echo -n "(Q) Do you want to add it into blacklist? (y/n) "
    while : ; do
        read yorn
        case $yorn in
            [Yy]) Add2Blacklist $1
               break;;
            [Nn]) # Nothing to do here.
               break;;
            *) echo "(I) Please choose [y] or [n]"
               echo -n "(A) ";;
        esac
    done
}

CheckModuleAndBlacklist() {
    checkmod="lsmod"
    modfile="mod.info"
    ${checkmod} > ${modfile} 2> ${trash}
    grep -q "usbtouchscreen" ${modfile}
    if [ $? -eq 0 ]; then
        echo "(I) Found inbuilt kernel module: usbtouchscreen"
        ShowBlacklistMenu "usbtouchscreen"
    fi
    rm -f ${modfile}
}

RestoreBlacklist() {
    if [ -w ${blacklistpath} ]; then
        grep -q "blacklist usbtouchscreen" ${blacklistpath}
        if [ $? -eq 0 ]; then
            sed -i '/### Beginning: blacklist usbtouchscreen ###/,/### End: blacklist usbtouchscreen ###/d' ${blacklistpath}
            echo "(I) Removed blacklist usbtouchscreen from ${blacklistpath}."
        fi
    fi
}

CheckAndLoadDrv() {
	checkdist="X -version"
    distfile="Dist.info"
    ${checkdist} > ${distfile} 2>&1
	
	grep -q "SUSE" ${distfile} 			# for Open SuSe 11.04
	if [ $? -eq 0 ]; then
		if [ -e ${xorgpath1}/${xorgfile} ]; then
			echo "(W) Found udev rule: ${xorgfile}."
		else
			echo "(I) Copy udev rule: ${xorgfile} to ${xorgpath1}."
			cp -f ${installpath}/${eGTouchfolder}/Rule/${xorgfile} ${xorgpath1}
		fi
	else
		if [ -e ${xorgpath}/${xorgfile} ]; then
			echo "(W) Found udev rule: ${xorgfile}."
		else
			echo "(I) Copy udev rule: ${xorgfile} to ${xorgpath}."
			cp -f ${installpath}/${eGTouchfolder}/Rule/${xorgfile} ${xorgpath}
		fi
	fi
	rm -f ${distfile}
}

RemoveLoadDrv() {
	if [ -e ${xorgpath}/${xorgfile} ]; then			# for Ubuntu 11.04 and Fedora 15
		rm -rf ${xorgpath}/${xorgfile}
		echo "(I) Removed udev rule: ${xorgpath}/${xorgfile}."
	else
		if [ -e ${xorgpath1}/${xorgfile} ]; then	# for Open SuSe 11.04
			rm -rf ${xorgpath1}/${xorgfile}
			echo "(I) Removed udev rule: ${xorgpath1}/${xorgfile}."
		else
			echo "(W) No udev rule: ${xorgfile} found."
		fi
	fi
}

RemoveDriver() {
    temppath=`find ${installpath} -name ${eGTouchD}`
    driverpath=${temppath%/*}
    if [ -z "${driverpath}" ]; then
        echo "(E) The driver archive has been removed already."
        echo ""
        exit 1
    elif [ -n "${driverpath}" ]; then
        ${eGTouchD} -k
        rm -rf ${driverpath}
        echo "(I) Removed ${drivername} driver archive from ${driverpath}."
    fi

    RemoveeGTouchFile
    RemoveShortcut
    RemoveRclocalConfiguration
    RestoreBlacklist
    RemoveLoadDrv
}

# Add/Remove ShortCut
AddShortCut() {
    #cp -f ${driverpath}/Rule/eGalaxCalib.png ${driverpath}
    cp -f ${driverpath}/Rule/eGalaxCalib48.png /usr/share/pixmaps/eGalaxCalib.png
    cp -f ${driverpath}/Rule/eGalaxCalib48.png /usr/share/icons/gnome/48x48/apps/eGalaxCalib.png
    cp -f ${driverpath}/Rule/eGalaxCalib.desktop /usr/share/applications

    if [ -f /usr/share/gnome-menus/update-gnome-menus-cache ] ; then
        /usr/share/gnome-menus/update-gnome-menus-cache /usr/share/applications > ~/desktop.en_US.utf8.cache
        mv ~/desktop.en_US.utf8.cache /usr/share/applications/desktop.en_US.utf8.cache
    fi
    echo "(I) Create ${utilityTool} shortcut."
}

RemoveShortCut() {
    rm -f /usr/share/pixmaps/eGalaxCalib.png
    rm -f /usr/share/icons/gnome/48x48/apps/eGalaxCalib.png
    rm -f /usr/share/applications/eGalaxCalib.desktop
    echo "(I) Removed ${utilityTool} shortcut."
}
# Add/Remove ShortCut

clear
ShowTitle

if [ $# = 0 ]; then
    CheckPermission
    ExtractDriver
    EditeGTouchdFile
    CheckModuleAndBlacklist
    CheckAndLoadDrv
	AddShortCut	# Add/Remove ShortCut
    echo ""
    echo "(I) Please reboot the system for some changes to take effect."
elif [ $# = 1 ]; then
    if [ $1 = "uninstall" ]; then
        CheckPermission
        echo "(I) Begin to remove ${drivername} driver."
        RemoveDriver
	RemoveShortCut # Add/Remove ShortCut
        echo ""
        echo "(I) The ${drivername} driver has been removed successfully."
        echo "(I) Please reboot the system for some changes to take effect."
    else
        echo "(I) Usage: sh $0 or sh $0 uninstall"
    fi
else
    echo "(I) Usage: sh $0 or sh $0 uninstall"
fi

echo ""
